//
//  $Id: WXKError.m 108 2009-06-24 14:54:10Z fujidana $
//  Copyright 2006 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "WXKError.h"


NSString *WXKErrorDomain = @"jp.sourceforge.kyoponutilities.WXKErrorDomain";


@implementation WXKError

+ (id)errorWithDomain:(NSString *)domain code:(int)code underlyingPOSIXErrorCode:(int)posixCode userInfo:(NSDictionary *)dict
{
	NSError *underlyingError = [NSError errorWithDomain:NSPOSIXErrorDomain code:posixCode userInfo:nil];
	NSMutableDictionary *newDict = [NSMutableDictionary dictionaryWithObject:underlyingError forKey:NSUnderlyingErrorKey];
	if (dict) [newDict addEntriesFromDictionary:dict];
	return [WXKError errorWithDomain:domain code:code userInfo:newDict];
}

- (NSString *)localizedDescription
{
	if ([[self domain] isEqualToString:WXKErrorDomain])
	{
		if ([[self userInfo] objectForKey:NSLocalizedDescriptionKey] == nil)
		{
			switch ([self code])
			{
				case WXKPhoneConnectionError:
					return NSLocalizedString(@"The AIR-EDGE PHONE wasn't connected.", @"error.phoneConnection.description");
				case WXKPhoneOpenPortError:
					return NSLocalizedString(@"Couldn't open a port for the AIR-EDGE PHONE.", @"error.openPort.description");
				case WXKPhoneConfigurePortError:
					return NSLocalizedString(@"Couldn't set the serial port options.", @"error.setSerialPortOptions.description");
				case WXKPhoneInapplicableDataLengthReceivedError:
					return NSLocalizedString(@"An illegal length data was received.", @"phone.InapplicableDataReceivedError.description");
				case WXKPhoneWriteSerialPortError:
					return NSLocalizedString(@"Couldn't write the serial port.", @"error.sendBytes.description");
				case WXKPhoneReadSerialPortError:
					return NSLocalizedString(@"Couldn't read the serial port.", @"error.receiveBytes.description");
				case WXKPhoneNotReadyError:
					return NSLocalizedString(@"The AIR-EDGE PHONE wasn't the top screen.", @"error.notTopScreen.description");
				case WXKPhoneInapplicablePasswordStringEncodingError:
					return NSLocalizedString(@"The security code contains incorrect characters.", @"error.passswordStringEncoding.description");
				case WXKPhoneInapplicablePasswordStringLengthError:
					return NSLocalizedString(@"The security code must consist of just 4 characters.", @"error.passswordStringLength.description");
				case WXKPhoneIncorrectPasswordError:
					return NSLocalizedString(@"Security code is incorrect.", @"error.incorrectPassword.description");
				case WXKPhoneInapplicableDataReceivedError:
					return NSLocalizedString(@"Illegal format data were found.", @"error.inapplicableDataReceived.description");
				case WXKPhoneMalformedItemSentError:
					return NSLocalizedString(@"The AIR-EDGE PHONE didn't return the success code.", @"error.failToSend.description");
				case WXKPhoneFilenameAndTypeConversionError:
					return NSLocalizedString(@"Failed to convert filename to Shift-JIS encoding. Incorrect characters might be contained.", @"error.filenameConvertError.description");
				case WXKPhoneUserCancelledError:
					return NSLocalizedString(@"Reading was interrupted by user.", @"error.userCancelledWhileReading.description");
				// case WXKPhoneNotLoggedInError:
				//	return NSLocalizedString(@"The application tried to log out but cellphone had not been logged in.", @"error.notLoggedIn.description");
				//case WXKPhoneGenericError:
				// WXKPhoneMalformedItemReceivedError,
				// WXKPhoneTooManyItemsSendingError,
				default:
					break;
			}
		}
	}
	return [super localizedDescription];
}

@end
